/**
 * \file: mlink_wfd_decoder_plugin_gstbuffer.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MLINK WiFi-Display Decoder plug-in
 *
 * \component: mlink
 *
 * \author: Ajay Kumar Sahoo ajaykumar.sahoo@in.bosch.com
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \history
 * 0.1 Ajay Kumar Sahoo Initial version
 *
 ***********************************************************************/

#ifndef DISABLE_WFD_PLUGIN

#include "mlink_wfd_decoder_plugin_gstbuffer.h"

/* PRQA: Lint Message Deactivation 160, 144, 19, 751 */
/*lint -e160 -e144 -e19 -e751 */

/* PRQA: Lint Message 826: deactivation because casting mechanism of GObject throws the finding */
/*lint -e826*/

GST_BOILERPLATE(GstWfdBuffer, gst_wfd_buffer, GstBuffer, GST_TYPE_BUFFER);
//GType gst_wfd_buffer_get_type (void);
//G_DEFINE_TYPE(GstWfdBuffer, gst_wfd_buffer, GST_TYPE_BUFFER);
static GstBufferClass *wfd_buffer_parent_class = NULL;

/**
 * \func gst_wfd_buffer_finalize
 * This function is called when the recount drops to 0 by the gstreamer
 * framework. The function calls the finalize method of the buffer object
 * if set.
 *
 * \param buffer "This" pointer
 *
 */
static void
gst_wfd_buffer_finalize(GstWfdBuffer * buffer)
{

    g_return_if_fail(buffer != NULL);

    if (NULL != buffer->finalize)
    {
        (buffer->finalize)(buffer);
    }
}

/**
 * \func gst_wfd_buffer_base_init
 * Initialize the class
 *
 * \param gclass Pointer to GstWfdBufferClass
 * *
 */
static void
gst_wfd_buffer_base_init(gpointer gclass)
{
    /* this function is intentionally blank */
    /* do not delete, it used by the get_type function */
    gclass = gclass;
}


/**
 * \func gst_wfd_buffer_init
 * Initialize the buffer
 *
 * \param buffer "This" pointer
 * \param klass Pointer to GstWfdBufferClass
 * *
 */
static void
gst_wfd_buffer_init(GstWfdBuffer * buffer, GstWfdBufferClass * klass)
{
    klass = klass;

    GST_BUFFER_DATA(buffer) = NULL;
    GST_BUFFER_SIZE(buffer) = 0;

    buffer->finalize = NULL;
    buffer->pDecoder = NULL;
    buffer->pPacket  = NULL;
}


/**
 * \func gst_wfd_buffer_class_init
 * Initialize the buffer class
 *
 * \param klass Pointer to GstWfdBufferClass
 * *
 */
static void
gst_wfd_buffer_class_init(GstWfdBufferClass * klass)
{

    printf("@aj:%s called \n",__FUNCTION__);

    GstMiniObjectClass *mini_object_class = GST_MINI_OBJECT_CLASS(klass);

    wfd_buffer_parent_class = (GstBufferClass*)g_type_class_peek_parent(klass);

    mini_object_class->finalize
               = (GstMiniObjectFinalizeFunction) gst_wfd_buffer_finalize;

    parent_class = (GstBufferClass*)g_type_class_peek_parent(klass);
}

/*lint +e160 +e144 +e19 +e751 */
/*lint +e826 */
#endif
